package com.actyve.openapi.sdk;

import com.actyve.openapi.sdk.utils.SignUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/test")
public class WebhookController {

    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    static String AppID = "1569641270953589506";
    static String PyvioPublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsIHIQAp4TToRZuF+/g/fr4xxJg/hGxyZGwp66l1LSS7sfsx/EnaCY0mYzEBZZ6qqEShdrtlowJa2SudemqeWbbH75vkcwvwL7cMX58pXNPny4vACaKSnIdz1wwue/tUWmubQdhb7wwJDDKB+TQoyhrZbNsW9tsASCu8WjdmxqH0i0It/FjrMw7R4pv0jrZfMmoZs0mhxnrF5HnPzRW+kFgKwDGIRzhsy32iMTk7lbOkSrBK923TuWy/mb5h3Vzw1c/PVtl9udFG2SbQsl848jXQx5TUhyh0XIVLVMRu/EAiq54bIsh/YNWx75nfCkH+h7T6d0L8qxIdQB/qdt/RZQwIDAQAB";

    @PostMapping("/webhook")
    public String webhook(@RequestHeader HttpHeaders headers,
                          @RequestBody String requestBody) {
        String sign = headers.getFirst("sign");
        String timestamp = headers.getFirst("x-timestamp");

        log.info("Received Pyvio Webhook: \nheaders: {}, \nbody: {}", headers, requestBody);

        String content = AppID + timestamp + requestBody;

        if (!SignUtils.rsaCheck(content, sign, PyvioPublicKey)) {
            log.info("AppId:{}, timestamp:{}, sign:{}", AppID, timestamp, sign);
            log.error("sign check failed! content: {}, sign: {}", content, sign);
        }


        return "OK";
    }
}
