package com.actyve.openapi.sdk.client;

public enum Endpoint {

    AccessTokenGet("/oauth/api/v1/token", Constants.HttpMethod.POST, false),

    // Account
    AddressGet("/actyve/api/v1/account/getAccount", Constants.HttpMethod.GET, true),
    BalanceGet("/actyve/api/v1/account/getAllBalance", Constants.HttpMethod.GET, true),

    // Payee
    PayeeCreate("/payee/api/v1/payee/create", Constants.HttpMethod.POST, true),
    PayeeUpdate("/payee/api/v1/payee/edit", Constants.HttpMethod.POST, true),
    PayeeGet("/payee/api/v1/payee/get", Constants.HttpMethod.GET, true),
    PayeeList("/payee/api/v1/payee/list", Constants.HttpMethod.GET, true),
    PayeeDelete("/payee/api/v1/payee/delete", Constants.HttpMethod.GET, true),

    // Chain Payee
    ChainPayeeCreate("/actyve/api/v1/payee/chain/add", Constants.HttpMethod.POST, true),
    ChainPayeeGet("/actyve/api/v1/payee/chain/get", Constants.HttpMethod.GET, true),
    ChainPayeeList("/actyve/api/v1/payee/chain/list", Constants.HttpMethod.GET, true),
    ChainPayeeDelete("/actyve/api/v1/payee/chain/delete", Constants.HttpMethod.GET, true),

    // Withdraw
    WithdrawCreate("/actyve/api/v1/withdraw/create", Constants.HttpMethod.POST, true),
    WithdrawGet("/actyve/api/v1/withdraw/get", Constants.HttpMethod.GET, true),
    WithdrawList("/actyve/api/v1/withdraw/list", Constants.HttpMethod.GET, true),

    // Acquire
    AcquireCreate("/actyve/api/v1/acquire/create", Constants.HttpMethod.POST, true),
    AcquireGet("/actyve/api/v1/acquire/get", Constants.HttpMethod.GET, true),
    AcquireList("/actyve/api/v1/acquire/list", Constants.HttpMethod.GET, true),
    DepositList("/actyve/api/v1/acquire/acquireDeposits", Constants.HttpMethod.GET, true),
    DepositScan("/actyve/api/v1/acquire/scan", Constants.HttpMethod.POST, true),

    // AcquireV2
    AcquireCreateV2("/actyve/api/v2/acquire/create", Constants.HttpMethod.POST, true),
    AcquireGetV2("/actyve/api/v2/acquire/get", Constants.HttpMethod.GET, true),
    AcquireListV2("/actyve/api/v2/acquire/list", Constants.HttpMethod.GET, true),

    // File
    FileUpload("/file/api/v1/upload", Constants.HttpMethod.POST, true),

    ;

    Endpoint(String url, String method, boolean authorization) {
        this.url = url;
        this.method = method;
        this.authorization = authorization;
    }

    private final String method;
    private final String url;
    private final boolean authorization;

    public String getMethod() {
        return method;
    }

    public String getUrl() {
        return url;
    }

    public boolean isAuthorization() {
        return authorization;
    }

    @Override
    public String toString() {
        return url;
    }
}
