package com.actyve.openapi.sdk.entity.info;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class AcquireChainInfo {
    /**
     * 链名称
     */
    private String chain_name;
    /**
     * 链地址
     */
    private String chain_address;
    /**
     * 支付信息
     */
    private List<PayAmountVO> pay_amount;

    @Data
    public static class PayAmountVO {
        /**
         * 币种 USDT/USDC
         */
        private String currency;
        /**
         * 金额
         */
        private BigDecimal amount;
        /**
         * 卖出币种
         */
        private String sell_currency;
        /**
         * 买入币种
         */
        private String buy_currency;
        /**
         *
         * 汇率
         */
        private BigDecimal rate;
    }
}
