package com.actyve.openapi.sdk.enums;

public class PayeeEnum {

    public enum PayeeType{
        BeneficiaryBankAccount("BeneficiaryBankAccount"),
        SupplierBankAccount("SupplierBankAccount"),
        EWallet("E-Wallet"),
        ;

        private final String code;

        PayeeType(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    public enum HolderType{
        Personal("Personal"),
        Company("Company"),
        ;

        private final String code;

        HolderType(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    public enum PaymentMethod{
        Local("Local"),
        SWIFT("SWIFT"),

        P2A("P2A"),
        BKash("BKash"),
        PIX("PIX"),
        PagBank("PagBank"),
        DANA("DANA"),
        Doku("Doku"),
        Linkaja("Linkaja"),
        OVO("OVO"),
        TouchnGo("Touch‘nGo"),
        Coins("Coins"),
        GCash("GCash"),
        GrabPay("GrabPay"),
        PayMaya("PayMaya"),
        Easypaisa("Easypaisa"),
        JazzCash("JazzCash"),
        ;

        private final String code;

        PaymentMethod(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    public enum RoutingType {

        ACH("ACH"),
        Fedwire("Fedwire"),
        Local("Local"),
        FPS("FPS"),
        Swift("Swift"),
        SEPA("SPEA"),
        RTGS("RTGS"),
        ;


        private final String code;

        RoutingType(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }
}
