package com.actyve.openapi.sdk.enums;


import java.util.stream.Stream;

public enum ResponseCodeEnum {

    SUCCESS("SUCCESS", "request success"),
    B_Auth_TokenInvalidError("B_Auth_TokenInvalidError", "token is invalid"),
    S_Common_NetworkError("S_Common_NetworkError", "network timeout"),
    S_Common_SystemError("S_Common_SystemError", "system error"),;
    ;

    private final String code;
    private final String msg;

    ResponseCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static ResponseCodeEnum getByCode(String code){
        return Stream.of(ResponseCodeEnum.values()).filter(a -> a.getCode().equals(code)).findAny().orElse(null);
    }
}
