package com.actyve.openapi.sdk.utils;

import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class OkHttpUtil {

    private static final Logger log = LoggerFactory.getLogger(OkHttpUtil.class);
    public static MediaType JSON = MediaType.parse("application/json; charset=utf-8");

    public static String get(String url, Map<String, String> queries) throws IOException {
        return get(url, null, queries);
    }

    public static String get(String url, Map<String, String> header, Map<String, String> queries) throws IOException {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            sb.append("?");
            AtomicInteger i = new AtomicInteger();
            queries.forEach((k, v) -> {
                if (!Objects.equals(v, "{}")) {
                    if (i.getAndIncrement() != 0) {
                        sb.append("&");
                    }
                    sb.append(k).append("=").append(v);
                }
            });
        }
        Request.Builder builder = new Request.Builder();
        if (header != null && header.keySet().size() > 0) {
            header.forEach(builder::addHeader);
        }

        Request request = builder.url(sb.toString()).build();
        return getBody(request);
    }

    public static String postJson(String url, String json) throws IOException {
        return postJson(url, null, json);
    }

    public static String postJson(String url, Map<String, String> header, String json) throws IOException {
        return postContent(url, header, json, JSON);
    }

    public static String postContent(String url, Map<String, String> header, String content, MediaType mediaType) throws IOException {
        RequestBody requestBody = RequestBody.create(mediaType, content);
        Request.Builder builder = new Request.Builder();

        if (header != null && header.keySet().size() > 0) {
            header.forEach(builder::addHeader);
        }
        Request request = builder.url(url).post(requestBody).build();
        return getBody(request);
    }

    private static String getBody(Request request) throws IOException {
        String responseBody = "";
        Response response = null;
        try {
            OkHttpClient okHttpClient = new OkHttpClient.Builder()
                    .connectTimeout(10, TimeUnit.SECONDS)//连接超时(单位:秒)
                    .readTimeout(30, TimeUnit.SECONDS)//读取超时(单位:秒)
                    .writeTimeout(30, TimeUnit.SECONDS)//写入超时(单位:秒)
                    .build();
            response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                responseBody = response.body().string();
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }

        return responseBody;
    }

    private static void setLogInfo(String msg) {
        log.info(msg);
    }

    private static void setLogError(String msg) {
        log.error(msg);
    }
}
