import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.entity.account.AddressQueryRequest;
import com.actyve.openapi.sdk.entity.account.AddressQueryResponse;
import com.actyve.openapi.sdk.entity.account.BalanceQueryRequest;
import com.actyve.openapi.sdk.entity.account.BalanceQueryResponse;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountTest extends BaseTest {
    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);

    @Test
    public void testAddressQueryRequest() {
        log.info("------------testAddressQueryRequest---------------");
        ActyveClient actyveClient = getClient(Endpoint.BalanceGet);

        AddressQueryRequest request = new AddressQueryRequest();

        AddressQueryResponse response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAddressQueryRequest---------------");
    }

    @Test
    public void testBalanceQueryRequest() {
        log.info("------------testBalanceQueryRequest---------------");
        ActyveClient actyveClient = getClient(Endpoint.BalanceGet);

        BalanceQueryRequest request = new BalanceQueryRequest();

        BalanceQueryResponse response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testBalanceQueryRequest---------------");
    }

}
