import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.entity.acquire.*;
import com.actyve.openapi.sdk.enums.AccountEnum;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;

public class AcquireTest extends BaseTest {
    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);

    @Test
    public void testAcquireCreate() {
        log.info("------------testAcquireCreate---------------");
        ActyveClient actyveClient = getClient(Endpoint.AcquireCreate);

        AcquireCreateRequest request = new AcquireCreateRequest();
        request.setAmount(BigDecimal.valueOf(100));
        request.setPartner_order_id("ac" + System.currentTimeMillis());
        request.setCurrency(AccountEnum.Currency.USDC.getCode());
        request.setChain_name(AccountEnum.ChainName.Tron.getCode());

        AcquireDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAcquireCreate---------------");
    }

    @Test
    public void testAcquireGet() {
        log.info("------------testAcquireGet---------------");
        ActyveClient actyveClient = getClient(Endpoint.AcquireGet);

        AcquireGetRequest request = new AcquireGetRequest();
        request.setOrder_id("AC1784840843458007235");

        AcquireDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAcquireGet---------------");

    }


    @Test
    public void testAcquireList() {
        log.info("------------testAcquireList---------------");
        ActyveClient actyveClient = getClient(Endpoint.AcquireList);

        AcquireListRequest request = new AcquireListRequest();

        AcquireListResponse response = (AcquireListResponse) actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAcquireList---------------");

    }


    @Test
    public void testDepositList() {
        log.info("------------testDepositList---------------");
        ActyveClient actyveClient = getClient(Endpoint.DepositList);

        DepositListRequest request = new DepositListRequest();

        DepositListResponse response = (DepositListResponse) actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testDepositList---------------");

    }


    @Test
    public void testDepositScan() {
        log.info("------------testDepositScan---------------");
        ActyveClient actyveClient = getClient(Endpoint.DepositScan);

        DepositScanRequest request = new DepositScanRequest();
        request.setOrder_id("AC1768124896485202023");
        request.setBegin_deposit_time(System.currentTimeMillis());
        request.setEnd_deposit_time(System.currentTimeMillis());

        DepositScanResponse response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testDepositScan---------------");

    }

}
