import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.entity.acquire.*;
import com.actyve.openapi.sdk.enums.AccountEnum;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;

import java.math.BigDecimal;

@Slf4j
public class AcquireV2Test extends BaseTest {

    @Test
    public void testAcquireV2Create() {
        log.info("------------testAcquireV2Create---------------");
        ActyveClient actyveClient = getClient(Endpoint.AcquireCreateV2);

        AcquireCreateRequestV2 request = new AcquireCreateRequestV2();
        request.setAmount(BigDecimal.valueOf(100));
        request.setPartner_order_id("ac" + System.currentTimeMillis());
        request.setCurrency(AccountEnum.Currency.USDT.getCode());
        String[] chains = {AccountEnum.ChainName.Tron.getCode(), AccountEnum.ChainName.Solana.getCode()};
        request.setChain_name(String.join(",", chains));
        request.setExpire_time(System.currentTimeMillis() + 20 * 60 * 1000);

        AcquireDTOV2 response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAcquireV2Create---------------");
    }

    @Test
    public void testAcquireV2Get() {
        log.info("------------testAcquireV2Get---------------");
        ActyveClient actyveClient = getClient(Endpoint.AcquireGetV2);

        AcquireGetRequestV2 request = new AcquireGetRequestV2();
        request.setOrder_id("AC1894301305388918317");

        AcquireDTOV2 response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAcquireV2Get---------------");

    }


    @Test
    public void testAcquireV2List() {
        log.info("------------testAcquireV2List---------------");
        ActyveClient actyveClient = getClient(Endpoint.AcquireListV2);

        AcquireListRequestV2 request = new AcquireListRequestV2();

        AcquireListResponseV2 response = (AcquireListResponseV2) actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testAcquireV2List---------------");

    }


    @Test
    public void testDepositList() {
        log.info("------------testDepositList---------------");
        ActyveClient actyveClient = getClient(Endpoint.DepositList);

        DepositListRequest request = new DepositListRequest();

        DepositListResponse response = (DepositListResponse) actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testDepositList---------------");

    }


}
