import com.actyve.openapi.sdk.client.ClientConfig;
import com.actyve.openapi.sdk.client.Constants;
import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.entity.authentication.AccessTokenGetRequest;
import com.actyve.openapi.sdk.entity.authentication.AccessTokenGetResponse;
import com.actyve.openapi.sdk.enums.AuthorizationEnum;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

@Slf4j
public class BaseTest {

    public static ActyveClient getClient(Endpoint endpoint){
        ClientConfig clientConfig = new ClientConfig();

        //sandbox
        clientConfig.setAppId("1569641270953589514");
        clientConfig.setAppSecret("e1128a332f9e1ef0edc881751734f66e");
        clientConfig.setDomainUrl(Constants.Url.SANDBOX_API);
        clientConfig.setDebug(true);
        clientConfig.setPrivateKey("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBALxGyg3/boLT2I8dQnC3Njc2XIDJgZM/G4wqsDDUVoy/PQ2THA39sKHiLsTg71zVbQZ4+UYWm1aTlms7KuBuOmvmdIzKuI04NbSuDeAbAtnraizhELSOpVQFNom2tIGHw4/46VuF3bE0rgFjKGqrRI9xOVEcDGZlP4h9JatQEgytAgMBAAECgYADZ1dX9Awy+A+NlAFm4BQrcXFy1xt7GIGUHaSUCe3N7sxY45uB+F+vyVh6aJm74QlCaJvmQv62Lg5t1HOQ2pcHD6/r7G0lykjYJ3JEAmF3KKm/FgPqX9MGqZCBNHp3oQaHMf8WwRfjxr/EBT1QfdItCGjiENJ4bjSJo9qzEPtjSQJBAMx/r6clsTUdpeskw60UMJG17Af5Fc/SNCsq8hdmCqva0QtT1l/vprmwEH1hKXlA9au9cIESp0ceABH86jE9Vu8CQQDrsTt/S6iiWAiJKA8eYWSEcPyQXoB+tveg4ZoKUwG+fT5t9tXOuPZGmC7CWsAATfO88/ySGqNyIlFgSDvTM3YjAkB+c9JdLCyI6L1pSwGIq/xgjbrXL0oyiQvjSZoLp/ifTh6Hv57HEfzpw5pevU8VAHspaGoCFlPD4SQv+1GhgwmXAkAd6grBJ1sp7751mg4BLx9Q5/5GXJg2fQaE9t1UPiDUipTn5BJTAIrRfvNAW8BOyZYL/3OpH5RrIgvuCnz9W2S9AkB19MQtKSc3Ba36Jo3C0kvTdeSDBR4o+ah+bzhwg/Hj8EKYp4IoyW8mx32WXtSLGp8OjupPlZ65PUkzy838Eo8v");

        ActyveClient actyveClient = new ActyveClient(clientConfig);
        if(endpoint.isAuthorization()){
            AccessTokenGetRequest tokenRequest = new AccessTokenGetRequest();
            tokenRequest.setApp_id(clientConfig.getAppId());
            tokenRequest.setApp_secret(clientConfig.getAppSecret());
            tokenRequest.setGrant_type(AuthorizationEnum.GrantType.ClientCredentials.getCode());
            AccessTokenGetResponse tokenResponse = actyveClient.execute(tokenRequest);
            if(!tokenResponse.isSuccess()){
                String errMsg = "Get Access Token Error.";
                if (!Objects.equals(tokenResponse.getErrorMsg(), "")) {
                    errMsg = tokenResponse.getErrorMsg();
                }
                throw new RuntimeException(errMsg);
            }
            clientConfig.setAccessToken(tokenResponse.getAccess_token());
        }
        return actyveClient;
    }

}
