import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.entity.chainPayee.*;
import com.actyve.openapi.sdk.enums.AccountEnum;
import com.actyve.openapi.sdk.enums.ChainPayeeEnum;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainPayeeTest extends BaseTest {

    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);

    @Test
    public void testChainPayeeCreate() {
        log.info("------------testChainPayeeCreate---------------");
        ActyveClient actyveClient = getClient(Endpoint.ChainPayeeCreate);

        ChainPayeeCreateRequest request = new ChainPayeeCreateRequest();
        request.setPartner_payee_id("cp" + System.currentTimeMillis());
        request.setChain_name(AccountEnum.ChainName.Tron.getCode());
        request.setChain_address("f0cc0c58fbbf45e29f8be4851172a2c3");
        request.setType(ChainPayeeEnum.AddressType.A2P.getCode());
        request.setPlatform("Binance");
        request.setIs_owner("Y");
        request.setNickname("nike name");

        ChainPayeeDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testChainPayeeCreate---------------");
    }

    @Test
    public void testChainPayeeGet() {
        log.info("------------testChainPayeeGet---------------");
        ActyveClient actyveClient = getClient(Endpoint.PayeeGet);

        ChainPayeeGetRequest request = new ChainPayeeGetRequest();
        request.setPartner_payee_id("cp1714463444231");

        ChainPayeeDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testChainPayeeGet---------------");
    }

    @Test
    public void testChainPayeeList() {
        log.info("------------testChainPayeeList---------------");
        ActyveClient actyveClient = getClient(Endpoint.ChainPayeeList);

        ChainPayeeListRequest request = new ChainPayeeListRequest();
        request.setPage_no(1);
        request.setPage_size(100);
        request.setChain_name(AccountEnum.ChainName.Tron.getCode());

        ChainPayeeListResponse response = (ChainPayeeListResponse) actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testChainPayeeList---------------");
    }

    @Test
    public void testChainPayeeDelete() {
        log.info("------------testDeletePayee---------------");
        ActyveClient actyveClient = getClient(Endpoint.ChainPayeeDelete);

        ChainPayeeDeleteRequest request = new ChainPayeeDeleteRequest();
        request.setPayee_id("CP2404301784840843458007156");

        ChainPayeeDeleteResponse response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testDeletePayee---------------");
    }

}
