import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.entity.info.BankAccountInfo;
import com.actyve.openapi.sdk.entity.info.PayeeInfo;
import com.actyve.openapi.sdk.entity.payee.*;
import com.actyve.openapi.sdk.enums.PayeeEnum;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayeeTest extends BaseTest{

    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);

    @Test
    public void testPayeeCreate(){
        log.info("------------testPayeeCreate---------------");
        ActyveClient actyveClient = getClient(Endpoint.PayeeCreate);

        PayeeInfo payeeInfo = new PayeeInfo();
        payeeInfo.setFirst_name("HOG");
        payeeInfo.setLast_name("WARTS");
        payeeInfo.setEmail("persion@test.com");
        payeeInfo.setPhone("533696800");
        payeeInfo.setPayee_country("US");
        payeeInfo.setProvince("California");
        payeeInfo.setCity("Los Angeles");
        payeeInfo.setPost_code("90001");
        payeeInfo.setStreet_address("123 Main Street");

        BankAccountInfo bankAccountInfo = new BankAccountInfo();
        bankAccountInfo.setAccount_no("6877028001");
        bankAccountInfo.setAccount_country("US");
        bankAccountInfo.setBank_name("CITI BANK");
        bankAccountInfo.setBank_address("11 PENNS WAY");
        bankAccountInfo.setAccount_name("account name");
        bankAccountInfo.setBank_code("023");
        bankAccountInfo.setBranch_address("5554 California Ave");
        bankAccountInfo.setBranch_code("1234");
        bankAccountInfo.setBranch_name("Oswell");
        bankAccountInfo.setSwift_code("CITIUS33");
        bankAccountInfo.setRouting_type1(PayeeEnum.RoutingType.ACH.getCode());
        bankAccountInfo.setRouting_value1("321171184");
        bankAccountInfo.setProvince("California");
        bankAccountInfo.setCity("Bakersfield");

        PayeeCreateRequest request = new PayeeCreateRequest();
        request.setPartner_payee_id("pe"+System.currentTimeMillis());
        request.setPayee_type(PayeeEnum.PayeeType.BeneficiaryBankAccount.getCode());
        request.setPayment_method(PayeeEnum.PaymentMethod.Local.getCode());
        request.setHolder_type(PayeeEnum.HolderType.Personal.getCode());
        request.setCurrency("USD");
        request.setBank_statement("47e1c595bd4c4499acb37d25ec73adc1");
        request.setPayee_info(payeeInfo);
        request.setBank_account_info(bankAccountInfo);

        PayeeDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testPayeeCreate---------------");
    }

    @Test
    public void testPayeeUpdate(){
        log.info("------------testPayeeCreate---------------");
        ActyveClient actyveClient = getClient(Endpoint.PayeeUpdate);

        PayeeInfo payeeInfo = new PayeeInfo();
        payeeInfo.setFirst_name("HOG");
        payeeInfo.setLast_name("WARTS");
        payeeInfo.setEmail("persion@test.com");
        payeeInfo.setPhone("533696800");
        payeeInfo.setPayee_country("US");
        payeeInfo.setProvince("California");
        payeeInfo.setCity("Los Angeles");
        payeeInfo.setPost_code("90001");
        payeeInfo.setStreet_address("123 Main Street");

        BankAccountInfo bankAccountInfo = new BankAccountInfo();
        bankAccountInfo.setAccount_no("6877028001");
        bankAccountInfo.setAccount_country("US");
        bankAccountInfo.setBank_name("CITI BANK");
        bankAccountInfo.setBank_address("11 PENNS WAY");
        bankAccountInfo.setAccount_name("account name");
        bankAccountInfo.setBank_code("023");
        bankAccountInfo.setBranch_address("5554 California Ave");
        bankAccountInfo.setBranch_code("1234");
        bankAccountInfo.setBranch_name("Oswell");
        bankAccountInfo.setSwift_code("CITIUS33");
        bankAccountInfo.setRouting_type1(PayeeEnum.RoutingType.ACH.getCode());
        bankAccountInfo.setRouting_value1("321171184");
        bankAccountInfo.setProvince("California");
        bankAccountInfo.setCity("Bakersfield");

        PayeeUpdateRequest request = new PayeeUpdateRequest();
        request.setPayee_id("ba1783369982565062211");
//        request.setPartner_payee_id("pe"+System.currentTimeMillis());
        request.setPayee_type(PayeeEnum.PayeeType.BeneficiaryBankAccount.getCode());
        request.setPayment_method(PayeeEnum.PaymentMethod.Local.getCode());
        request.setHolder_type(PayeeEnum.HolderType.Personal.getCode());
        request.setCurrency("USD");
        request.setBank_statement("47e1c595bd4c4499acb37d25ec73adc1");
        request.setPayee_info(payeeInfo);
        request.setBank_account_info(bankAccountInfo);

        PayeeDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testPayeeCreate---------------");
    }

    @Test
    public void testGetPayee(){
        log.info("------------PayeeGetResponse---------------");
        ActyveClient actyveClient = getClient(Endpoint.PayeeGet);

        PayeeGetRequest request = new PayeeGetRequest();
        request.setPartner_payee_id("pe1714458104222");

        PayeeDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------PayeeGetResponse---------------");
    }

    @Test
    public void testListPayee(){
        log.info("------------testListPayee---------------");
        ActyveClient actyveClient = getClient(Endpoint.PayeeGet);

        PayeeListRequest request = new PayeeListRequest();

        PayeeListResponse response = (PayeeListResponse)actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testListPayee---------------");
    }

    @Test
    public void testDeletePayee(){
        log.info("------------testDeletePayee---------------");
        ActyveClient actyveClient = getClient(Endpoint.PayeeDelete);

        PayeeDeleteRequest request = new PayeeDeleteRequest();
        request.setPayee_id("ba1783369982565062211");

        PayeeDeleteResponse response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testDeletePayee---------------");
    }

}
