import com.actyve.openapi.sdk.client.ActyveClient;
import com.actyve.openapi.sdk.client.Endpoint;
import com.actyve.openapi.sdk.entity.withdraw.*;
import com.actyve.openapi.sdk.enums.WithdrawEnum;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;

public class WithdrawTest extends BaseTest {
    private static final Logger log = LoggerFactory.getLogger(BaseTest.class);

    @Test
    public void testWithdrawCreate() {
        log.info("------------testWithdrawCreate---------------");
        ActyveClient actyveClient = getClient(Endpoint.WithdrawCreate);

        WithdrawCreateRequest request = new WithdrawCreateRequest();
        request.setCurrency(WithdrawEnum.Currency.USDT.getCode());
        request.setAmount(BigDecimal.valueOf(0.1));
        request.setTarget_address("a592b52728cf44aeb3a2227e6aec0aa7");
        request.setOrder_type(WithdrawEnum.OrderType.GlobalAccount.getCode());
        request.setPartner_order_id("w" + System.currentTimeMillis());

        WithdrawDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));
        log.info("------------testWithdrawCreate---------------");
    }

    @Test
    public void testWithdrawGet() {
        log.info("------------testWithdrawGet---------------");

        ActyveClient actyveClient = getClient(Endpoint.WithdrawGet);
        WithdrawGetRequest request = new WithdrawGetRequest();
        request.setOrder_id("W1784840843458007182");

        WithdrawDTO response = actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));

        log.info("------------testWithdrawGet---------------");
    }

    @Test
    public void testWithdrawList() {
        log.info("------------testWithdrawList---------------");

        ActyveClient actyveClient = getClient(Endpoint.WithdrawGet);
        WithdrawListRequest request = new WithdrawListRequest();

        WithdrawListResponse response = (WithdrawListResponse) actyveClient.execute(request);
        System.out.println(JSONObject.toJSONString(response));

        log.info("------------testWithdrawList---------------");
    }

}
